local class_name = "g_counterfeit_stealth"
local loc = _G[class_name.."_loc"]

Hooks:Add("LocalizationManagerPostInit", class_name.."Loc", function(loc)
	LocalizationManager:add_localized_strings({
		[class_name.."_menu_title"] = "Counterfeit Stealth",
		[class_name.."_menu_desc"] = "Stealth counterfeit.",
		
		["player_on_street_title"] = "Allow Street",
		["player_on_street_desc"] = "Players can roam the streets without anyone calling the police.",
		["toggle_title"] = "Toggle Mod",
		["toggle_desc"] = "Toggle if counterfeit can be stealthed or not.",
		["glass_title"] = "Glass Alert",
		["glass_desc"] = "Toggle if breaking glass will alert police."
	})
end)

Hooks:Add("MenuManagerSetupCustomMenus", class_name.."Menu", function(menu_manager, nodes)
	MenuHelper:NewMenu(class_name)
end)

Hooks:Add("MenuManagerPopulateCustomMenus", class_name.."Menu", function(menu_manager, nodes)
	MenuCallbackHandler.player_on_street = function(self, item)
		loc.config.player_on_street = not loc.config.player_on_street
		loc:save_config()
	end
	
	MenuHelper:AddToggle({
		id = "player_on_street",
		title = "player_on_street_title",
		desc = "player_on_street_desc",
		callback = "player_on_street",
		value = loc.config.player_on_street,
		menu_id = class_name,  
		priority = 1
	})
	
	MenuCallbackHandler.glass = function(self, item)
		loc.config.glass = not loc.config.glass
		loc:save_config()
	end
	
	MenuHelper:AddToggle({
		id = "glass",
		title = "glass_title",
		desc = "glass_desc",
		callback = "glass",
		value = loc.config.glass,
		menu_id = class_name,  
		priority = 2
	})
	
	MenuCallbackHandler.toggle = function(self, item)
		loc.config.toggle = not loc.config.toggle
		loc:save_config()
	end
	
	MenuHelper:AddToggle({
		id = "toggle",
		title = "toggle_title",
		desc = "toggle_desc",
		callback = "toggle",
		value = loc.config.toggle,
		menu_id = class_name,  
		priority = 3
	})
end)

Hooks:Add("MenuManagerBuildCustomMenus", class_name.."Menu", function(menu_manager, nodes)
	nodes[class_name] = MenuHelper:BuildMenu(class_name)
	MenuHelper:AddMenuItem(nodes["blt_options"], class_name, class_name.."_menu_title", class_name.."_menu_desc")
end)